#include "mods/bf2/shaders/datatypes.fx"

texture texture0 : TEXLAYER0;
texture texture1 : TEXLAYER1;
texture texture2 : TEXLAYER2;
texture texture3 : TEXLAYER3;
texture texture4 : TEXLAYER4;
texture texture5 : TEXLAYER5;
texture texture6 : TEXLAYER6;

scalar backbufferLerpbias : BACKBUFFERLERPBIAS;
vec2 sampleoffset : SAMPLEOFFSET;
vec2 fogStartAndEnd : FOGSTARTANDEND;
vec3 fogColor : FOGCOLOR;
float glowStrength : GLOWSTRENGTH;

float nightFilter_noise_strength : NIGHTFILTER_NOISE_STRENGTH;
float nightFilter_noise : NIGHTFILTER_NOISE;
float nightFilter_blur : NIGHTFILTER_BLUR;
float nightFilter_mono : NIGHTFILTER_MONO;

float2 displacement : DISPLACEMENT;

float PI = 3.1415926535897932384626433832795;

// one pixel in screen texture units
float deltaU : DELTAU;
float deltaV : DELTAV;

sampler sampler0 = sampler_state { Texture = (texture0); AddressU = CLAMP; AddressV = CLAMP; MinFilter = POINT; MagFilter = POINT; };
sampler sampler1 = sampler_state { Texture = (texture1); AddressU = CLAMP; AddressV = CLAMP; MinFilter = POINT; MagFilter = POINT; };
sampler sampler2 = sampler_state { Texture = (texture2); AddressU = CLAMP; AddressV = CLAMP; MinFilter = POINT; MagFilter = POINT; };
sampler sampler3 = sampler_state { Texture = (texture3); AddressU = CLAMP; AddressV = CLAMP; MinFilter = POINT; MagFilter = POINT; };
sampler sampler4 = sampler_state { Texture = (texture4); AddressU = CLAMP; AddressV = CLAMP; MinFilter = POINT; MagFilter = POINT; };
sampler sampler5 = sampler_state { Texture = (texture5); AddressU = CLAMP; AddressV = CLAMP; MinFilter = POINT; MagFilter = POINT; };
sampler sampler6 = sampler_state { Texture = (texture6); AddressU = CLAMP; AddressV = CLAMP; MinFilter = POINT; MagFilter = POINT; };

sampler sampler0bilin = sampler_state { Texture = (texture0); AddressU = CLAMP; AddressV = CLAMP; MinFilter = LINEAR; MagFilter = LINEAR; };
sampler sampler1bilin = sampler_state { Texture = (texture1); AddressU = CLAMP; AddressV = CLAMP; MinFilter = LINEAR; MagFilter = LINEAR; };
sampler sampler2bilin = sampler_state { Texture = (texture2); AddressU = CLAMP; AddressV = CLAMP; MinFilter = LINEAR; MagFilter = LINEAR; };
sampler sampler3bilin = sampler_state { Texture = (texture3); AddressU = CLAMP; AddressV = CLAMP; MinFilter = LINEAR; MagFilter = LINEAR; };
sampler sampler4bilin = sampler_state { Texture = (texture4); AddressU = CLAMP; AddressV = CLAMP; MinFilter = LINEAR; MagFilter = LINEAR; };
sampler sampler5bilin = sampler_state { Texture = (texture5); AddressU = CLAMP; AddressV = CLAMP; MinFilter = LINEAR; MagFilter = LINEAR; };

sampler sampler0bilinwrap = sampler_state { Texture = (texture0); AddressU = WRAP; AddressV = WRAP; AddressW = WRAP; MinFilter = LINEAR; MagFilter = LINEAR; };
sampler sampler1bilinwrap = sampler_state { Texture = (texture1); AddressU = WRAP; AddressV = WRAP; AddressW = WRAP; MinFilter = LINEAR; MagFilter = LINEAR; };
sampler sampler2bilinwrap = sampler_state { Texture = (texture2); AddressU = WRAP; AddressV = WRAP; AddressW = WRAP; MinFilter = LINEAR; MagFilter = LINEAR; };
sampler sampler3bilinwrap = sampler_state { Texture = (texture3); AddressU = WRAP; AddressV = WRAP; AddressW = WRAP; MinFilter = LINEAR; MagFilter = LINEAR; };
sampler sampler4bilinwrap = sampler_state { Texture = (texture4); AddressU = WRAP; AddressV = WRAP; AddressW = WRAP; MinFilter = LINEAR; MagFilter = LINEAR; };
sampler sampler5bilinwrap = sampler_state { Texture = (texture5); AddressU = WRAP; AddressV = WRAP; AddressW = WRAP; MinFilter = LINEAR; MagFilter = LINEAR; };

scalar NPixels : NPIXLES = 1.0;
vec2 ScreenSize : VIEWPORTSIZE = {800,600};
scalar Glowness : GLOWNESS = 3.0;
scalar Cutoff : cutoff = 0.8;


struct APP2VS_Quad
{
    vec2	Pos : POSITION0;
    vec2	TexCoord0 : TEXCOORD0;
};

struct VS2PS_Quad
{
    vec4	Pos 		: POSITION;
    vec2	TexCoord0	: TEXCOORD0;
};

struct VS2PS_Quad2
{
    vec4	Pos 		: POSITION;
    vec2	TexCoord0	: TEXCOORD0;
    vec2	TexCoord1	: TEXCOORD1;
};

struct VS2PS_Quad3
{
    vec4	Pos 		: POSITION;
    vec2	TexCoord0	: TEXCOORD0;
    vec2	TexCoord1	: TEXCOORD1;
    vec2	TexCoord2	: TEXCOORD2;
};

struct VS2PS_Quad4
{
    vec4	Pos 		: POSITION;
    vec2	TexCoord0	: TEXCOORD0;
    vec2	TexCoord1	: TEXCOORD1;
    vec2	TexCoord2	: TEXCOORD2;
    vec2	TexCoord3	: TEXCOORD3;
};

struct VS2PS_Quad5
{
    vec4	Pos 		: POSITION;
    vec2	Color0		: COLOR0;
    vec2	TexCoord0	: TEXCOORD0;
    vec2	TexCoord1	: TEXCOORD1;
};

struct PS2FB_Combine
{
    vec4	Col0 		: COLOR0;
};

VS2PS_Quad vsDx9_OneTexcoord(APP2VS_Quad indata)
{
	VS2PS_Quad outdata;	
 	outdata.Pos = vec4(indata.Pos.x, indata.Pos.y, 0, 1);
 	outdata.TexCoord0 = indata.TexCoord0;
	return outdata;
}

#if !_FORCE_1_3_SHADERS_

VS2PS_Quad2 vsDx9_Tinnitus(APP2VS_Quad indata)
{
	VS2PS_Quad2 outdata;	
 	outdata.Pos = vec4(indata.Pos.x, indata.Pos.y, 0, 1);
 	outdata.TexCoord0 = indata.TexCoord0;
 	outdata.TexCoord1 = vec2(indata.TexCoord0.x - sampleoffset.x, indata.TexCoord0.y - sampleoffset.y);	
	return outdata;
}

PS2FB_Combine psDx9_Tinnitus(VS2PS_Quad2 indata)
{
	PS2FB_Combine outdata;
	
	vec4 sample0 = tex2D(sampler0bilin, indata.TexCoord1);
	vec4 sample1 = tex2D(sampler1bilin, indata.TexCoord1);
	vec4 sample2 = tex2D(sampler2bilin, indata.TexCoord1);
	vec4 sample3 = tex2D(sampler3bilin, indata.TexCoord1);

	vec4 accum = sample0 * 0.5;
	accum += sample1 * 0.250;
	accum += sample2 * 0.125;
	accum += sample3 * 0.125;
	accum.a = backbufferLerpbias;

	outdata.Col0 = accum;
	return outdata;
}

#else

VS2PS_Quad4 vsDx9_Tinnitus(APP2VS_Quad indata)
{
	VS2PS_Quad4 outdata;	
 	outdata.Pos = vec4(indata.Pos.x, indata.Pos.y, 0, 1);
 	outdata.TexCoord0 = vec2(indata.TexCoord0.x - sampleoffset.x, indata.TexCoord0.y - sampleoffset.y);	
 	outdata.TexCoord1 = outdata.TexCoord0;
 	outdata.TexCoord2 = outdata.TexCoord0;
 	outdata.TexCoord3 = outdata.TexCoord0;
	return outdata;
}

PS2FB_Combine psDx9_Tinnitus(VS2PS_Quad4 indata)
{
	PS2FB_Combine outdata;
	
	vec4 sample0 = tex2D(sampler0bilin, indata.TexCoord0);
	vec4 sample1 = tex2D(sampler1bilin, indata.TexCoord1);
	vec4 sample2 = tex2D(sampler2bilin, indata.TexCoord2);
	vec4 sample3 = tex2D(sampler3bilin, indata.TexCoord3);

	vec4 accum = sample0 * 0.5;
	accum += sample1 * 0.250;
	accum += sample2 * 0.125;
	accum += sample3 * 0.125;
	accum.a = backbufferLerpbias;

	outdata.Col0 = accum;
	return outdata;
}

#endif

technique Tinnitus
{
	pass opaque
	{
		ZEnable = FALSE;
		AlphaBlendEnable = TRUE;
		SrcBlend = SRCALPHA;
		DestBlend = INVSRCALPHA;
		StencilEnable = FALSE;
		
		VertexShader = compile vs_1_1 vsDx9_Tinnitus();
		//PixelShader = compile PS2_EXT psDx9_Tinnitus();
		PixelShader = compile LOWPSMODEL psDx9_Tinnitus();
	}
}

vec4 psDx9_Glow(VS2PS_Quad indata) : COLOR
{
	return tex2D(sampler0bilin, indata.TexCoord0);
}

vec4 psDx9_GlowMaterial(VS2PS_Quad indata) : COLOR
{
	vec4 diffuse =  tex2D(sampler0bilin, indata.TexCoord0);
	//return (1-diffuse.a);
	// temporary test, should be removed
	return glowStrength * /*diffuse + */vec4(diffuse.rgb*(1-diffuse.a),1);
}

technique GlowMaterial
{
	pass p0
	{
		ZEnable = FALSE;
		AlphaBlendEnable = FALSE;
		SrcBlend = SRCCOLOR;
		DestBlend = ONE;
		

		StencilEnable = TRUE;
		StencilFunc = NOTEQUAL;
		StencilRef = 0x80;
		StencilMask = 0xFF;
		StencilFail = KEEP;
		StencilZFail = KEEP;
		StencilPass = KEEP;
	

		
		VertexShader = compile vs_1_1 vsDx9_OneTexcoord();
		PixelShader = compile ps_1_1 psDx9_GlowMaterial();
	}
}




technique Glow
{
	pass p0
	{
		ZEnable = FALSE;
		AlphaBlendEnable = TRUE;
		SrcBlend = SRCCOLOR;
		DestBlend = ONE;
		
		
		VertexShader = compile vs_1_1 vsDx9_OneTexcoord();
		PixelShader = compile ps_1_1 psDx9_Glow();
	}
}

vec4 psDx9_Fog(VS2PS_Quad indata) : COLOR
{
	vec3 wPos = tex2D(sampler0, indata.TexCoord0);
	scalar uvCoord =  saturate((wPos.zzzz-fogStartAndEnd.r)/fogStartAndEnd.g);//fogColorAndViewDistance.a);
	return saturate(vec4(fogColor.rgb,uvCoord));
	//vec2 fogcoords = vec2(uvCoord, 0.0);
	return tex2D(sampler1, vec2(uvCoord, 0.0))*fogColor.rgbb;
}

/*
technique Fog
{
	pass p0
	{
		ZEnable = FALSE;
		AlphaBlendEnable = TRUE;
		//SrcBlend = SRCCOLOR;
		//DestBlend = ZERO;
		SrcBlend = SRCALPHA;
		DestBlend = INVSRCALPHA;
		//StencilEnable = FALSE;
		
		StencilEnable = TRUE;
		StencilFunc = NOTEQUAL;
		StencilRef = 0x00;
		StencilMask = 0xFF;
		StencilFail = KEEP;
		StencilZFail = KEEP;
		StencilPass = KEEP;
		
		VertexShader = compile vs_1_1 vsDx9_OneTexcoord();
		PixelShader = compile ps_2_0 psDx9_Fog();
	}
}
*/
// TVEffect specific...

scalar time_0_X : FRACTIME;
scalar time_0_X_256 : FRACTIME256;
float sin_time_0_X : FRACSINE;

float interference : INTERFERENCE; // = 0.050000;
float distortionRoll : DISTORTIONROLL; // = 0.100000;
float distortionScale : DISTORTIONSCALE; // = 0.500000;
float distortionFreq : DISTORTIONFREQ; //= 0.500000;
float granularity : TVGRANULARITY; // = 3.5;
float tvAmbient : TVAMBIENT; // = 0.15;

vec3 tvColor : TVCOLOR;

VS2PS_Quad3 vs_TVEffect( APP2VS_Quad indata )
{
   VS2PS_Quad3 output;

   // RenderMonkeyHACK Clean up inaccuracies
   indata.Pos.xy = sign(indata.Pos.xy);

   output.Pos = float4(indata.Pos.xy, 0, 1);
   output.TexCoord0 = indata.Pos.xy * granularity + displacement;
//   output.TexCoord1 = 0.5 * float2(0.5 * pos.y, 0.1 * time_0_X);
   output.TexCoord1 = float2(indata.Pos.x * 0.25 - 0.35 * sin_time_0_X, 
							 indata.Pos.y * 0.25 + 0.25 * sin_time_0_X);
   output.TexCoord2 = indata.TexCoord0;

   return output;
}

PS2FB_Combine ps_TVEffect20(VS2PS_Quad3 indata) {

   PS2FB_Combine outdata;

	float2 pos = indata.TexCoord0;
	float2 img = indata.TexCoord2;

   // Interference ... just a texture filled with rand()
   float rand = tex2D(sampler2bilinwrap, pos) - 0.2;

   // Some signed noise for the distortion effect
   float noisy = tex2D(sampler1bilinwrap, indata.TexCoord1) - 0.5;

   // Repeat a 1 - x^2 (0 < x < 1) curve and roll it with sinus.
   float dst = frac(pos.y * distortionFreq + distortionRoll * sin_time_0_X);
   dst *= (1 - dst);
   // Make sure distortion is highest in the center of the image
   dst /= 1 + distortionScale * abs(pos.y);

   // ... and finally distort
   img.x += distortionScale * noisy * dst;
   float4 image = /*float4(0.9, 1.1, 1.1, 0) * */dot(float3(0.3,0.59,0.11), tex2D(sampler0bilin, img));

   // Combine frame, distorted image and interference
   outdata.Col0 = float4(tvColor,1) * (interference * rand + image * (1-tvAmbient) + tvAmbient);  

   return outdata;
}

PS2FB_Combine ps_TVEffect14(VS2PS_Quad3 indata) {

   PS2FB_Combine outdata;

   float2 pos = indata.TexCoord0;
   float2 img = indata.TexCoord1;

   // Interference ... just a texture filled with rand()
   float rand = tex2D(sampler2bilinwrap, indata.TexCoord0) - 0.2;

   // Some signed noise for the distortion effect
   float noisy = tex2D(sampler1bilinwrap, indata.TexCoord1) - 0.5;

   float4 image = dot(float3(0.3,0.59,0.11), tex2D(sampler0bilin, indata.TexCoord2));

   // Combine frame, distorted image and interference
   outdata.Col0 = float4(tvColor,1) * (interference * rand + image);

   return outdata;
}

//
//	TV Effect with usage of gradient texture
//

PS2FB_Combine ps_TVEffect_Gradient_Tex(VS2PS_Quad3 indata)
{
   PS2FB_Combine outdata;

	float2 pos = indata.TexCoord0;
	float2 img = indata.TexCoord2;
   
   // Interference ... just a texture filled with rand()
   float rand = tex2D(sampler2bilinwrap, pos) - 0.2;
   
   // Some signed noise for the distortion effect
   float noisy = tex2D(sampler1bilinwrap, indata.TexCoord1) - 0.5;

   // Repeat a 1 - x^2 (0 < x < 1) curve and roll it with sinus.
   float dst = frac(pos.y * distortionFreq + distortionRoll * sin_time_0_X);
   dst *= (1 - dst);
   // Make sure distortion is highest in the center of the image
   dst /= 1 + distortionScale * abs(pos.y);

   // ... and finally distort
   img.x += distortionScale * noisy * dst;

   float4 image = dot(float3(0.3,0.59,0.11), tex2D(sampler0bilin, img));

   // Combine frame, distorted image and interference
   float4 intensity = (interference * rand + image * (1-tvAmbient) + tvAmbient);
   
   // Map the intensity to gradient map color
   float4 gradient_col = tex2D(sampler3bilin, float2(intensity.r,0.f));
   
   // Combine the final color from gradient and intensity alpha (just in case there's anything there)
   outdata.Col0 = float4( gradient_col.rgb, intensity.a );

   return outdata;
}

PS2FB_Combine ps_TVEffect13(VS2PS_Quad3 indata)
{
   PS2FB_Combine outdata;

   // Interference ... just a texture filled with rand()
   float rand = tex2D(sampler2bilinwrap, indata.TexCoord0) - 0.2;
   
   // Add noise to the randomness
   //float rand_noise = tex2D(sampler1bilinwrap, pos2);
   //rand = rand * rand_noise;
   
   float4 image = dot(float3(0.3,0.59,0.11), tex2D(sampler0bilin, indata.TexCoord2));

   // Combine frame, distorted image and interference
   float4 intensity = (interference * rand + image);
    
   // Combine the final color from gradient and intensity alpha (just in case there's anything there)
   outdata.Col0 = intensity * float4(tvColor,1);

   return outdata;
}

technique TVEffect
{
	pass p0
	{
		ZEnable = FALSE;
		AlphaBlendEnable = FALSE;

		StencilEnable = FALSE;

		VertexShader = compile vs_1_1 vs_TVEffect();

#if !_FORCE_1_4_SHADERS_
			PixelShader = compile PS2_EXT ps_TVEffect20();
#else
			PixelShader = compile LOWPSMODEL ps_TVEffect14();
#endif		
	}
}

technique TVEffect_Gradient_Tex
{
	pass p0
	{
		ZEnable = FALSE;
		AlphaBlendEnable = FALSE;
		StencilEnable = FALSE;
		
		VertexShader = compile vs_1_1 vs_TVEffect();
		
#if !_FORCE_1_4_SHADERS_
		PixelShader = compile ps_2_0 ps_TVEffect_Gradient_Tex();
#else
		PixelShader = compile LOWPSMODEL ps_TVEffect14();
#endif
	}
}

/*
//
//	Night filter
//

VS2PS_Quad2 vs_NightFilter( APP2VS_Quad indata )
{
   VS2PS_Quad2 output;

   // RenderMonkeyHACK Clean up inaccuracies
   indata.Pos.xy = sign(indata.Pos.xy);

   output.Pos = float4(indata.Pos.xy, 0, 1);
   output.TexCoord0 = indata.Pos.xy;
   output.TexCoord1 = indata.TexCoord0;

   return output;
}

PS2FB_Combine ps_NightFilter(VS2PS_Quad2 indata)
{
   PS2FB_Combine outdata;

   float2 pos = indata.TexCoord0;
   float2 img = indata.TexCoord1;

   // Interference ... just a texture filled with rand()
   float rand = tex2D(sampler1bilinwrap, float2(granularity * pos) + frac(128 * time_0_X));  
   rand = rand*nightFilter_noise_strength+(1-nightFilter_noise_strength);
   
   // sample the original image
   float4 image = tex2D(sampler0, img);
    
   // sample blurred image 
   float3 blurred = float3(0,0,0);
   blurred += tex2D(sampler2bilin, float2(img.x, img.y));
   blurred += tex2D(sampler2bilin, float2(img.x-deltaU, img.y));
   blurred += tex2D(sampler2bilin, float2(img.x+deltaU, img.y));
   blurred += tex2D(sampler2bilin, float2(img.x, img.y-deltaV));
   blurred += tex2D(sampler2bilin, float2(img.x, img.y+deltaV));
   blurred /= 5;
	  
   // calculate brightness for blending
	float brightness = dot(image.rgb,float3(1,1,1));
   
   // these are inverse weights  
   float rand_weight = min(brightness*nightFilter_noise,1);
   float blur_weight = min(brightness*nightFilter_blur,1);
   float gray_weight = min(brightness*nightFilter_mono,1);
   
   float final_rand = lerp(rand,1,rand_weight);
   float4 final_blurred = lerp(float4(blurred,image.a),image,blur_weight);
   float final_gray = ((final_blurred.r+final_blurred.g+final_blurred.b)/3);
   float4 final_col = lerp(final_gray,final_blurred,gray_weight);
   
   outdata.Col0 = final_col * final_rand;
//   outdata.Col0 = image;
   
   return outdata;
}

technique NightFilter
{
	pass p0
	{
		ZEnable = FALSE;
		AlphaBlendEnable = FALSE;
		StencilEnable = FALSE;
		
		VertexShader = compile vs_1_1 vs_NightFilter();
		PixelShader = compile ps_2_0 ps_NightFilter();
	}
}
*/

//
//	Wave Distortion
//

VS2PS_Quad2 vs_WaveDistortion( APP2VS_Quad indata )
{
   VS2PS_Quad2 output;

   // RenderMonkeyHACK Clean up inaccuracies
   //indata.Pos.xy = sign(indata.Pos.xy); // this causes problems

   output.Pos = float4(indata.Pos.xy, 0, 1);
   output.TexCoord0 = indata.TexCoord0;
   
#if _FORCE_1_4_SHADERS_ || _FORCE_1_3_SHADERS_
   float2 posDistort = float2( indata.Pos.x * 5.7 + indata.Pos.y * 2.8,
						       indata.Pos.x * 2.9 + indata.Pos.y * 3.3);

   float2 cosSinDistort = float2( (posDistort.x + time_0_X * PI*4),
								  (posDistort.y + time_0_X * PI*2) );

	// map to texture space
   output.TexCoord1 = cosSinDistort / (2*PI);  
#else
   output.TexCoord1 = indata.Pos.xy;
#endif
   
   return output;
}

PS2FB_Combine ps_WaveDistortion(VS2PS_Quad2 indata)
{
	PS2FB_Combine outdata;	

#if _FORCE_1_4_SHADERS_
	// do per vertex with sampling cos & sin from a texture
	float2 distort = tex2D(sampler1bilinwrap, indata.TexCoord1).gb;
	distort = distort*2 - 1;
#else
	// do per pixel
    float2 posDistort = float2( indata.TexCoord1.x * 5.7 + indata.TexCoord1.y * 2.8,
						        indata.TexCoord1.x * 2.9 + indata.TexCoord1.y * 3.3);

	float2 cosSinDistort = float2( (posDistort.x + time_0_X * PI*4),
						           (posDistort.y + time_0_X * PI*2) );

	float2 distort = float2( cos(cosSinDistort.x),
							 sin(cosSinDistort.y) );
#endif

#if !_FORCE_1_3_SHADERS_
	distort *= float2(deltaU,deltaV);
	outdata.Col0 = tex2D(sampler0bilin, indata.TexCoord0+distort);
#else
	outdata.Col0 = tex2D(sampler0bilin, indata.TexCoord0);
#endif
	outdata.Col0.a = backbufferLerpbias;
	return outdata;
}
/*
float4x4 UpScaleTexBy8 =
{
 8,0,0,0,
 0,8,0,0,
 0,0,1,0,
 0,0,0,1
};
*/
technique WaveDistortion
{
	pass p0
	{
		ZEnable = FALSE;
		AlphaBlendEnable = TRUE;
		AlphaTestEnable = FALSE;
		StencilEnable = FALSE;
		SrcBlend = SRCALPHA;
		DestBlend = INVSRCALPHA;

		//PixelShaderConstant2[0] = <time_0_X>;
		//PixelShaderConstant1[1] = <deltaU>;
		//PixelShaderConstant1[2] = <deltaV>;

		//TextureTransform[2] = <UpScaleTexBy8>;
		
		VertexShader = compile vs_1_1 vs_WaveDistortion();
		
#if _FORCE_1_4_SHADERS_		
		PixelShader = compile ps_1_4 ps_WaveDistortion();
#elif _FORCE_1_3_SHADERS_
		PixelShader = compile LOWPSMODEL ps_WaveDistortion();
#else
		PixelShader = compile PS2_EXT ps_WaveDistortion();
#endif		
/*
		PixelShader = asm
		{
			ps_1_3
			def c2, 2,1,0,0

			texcoord t2
			mov r0, t2
			
			// time_0_X * PI, all of this should be precomputed
			mov r1, c0
			mul r1, c1, r1_x2
			mul r1, r1, c2
			
			add r1, r0, r1
			
			// sample cosine texture
			texreg2rgb r0, r1
			
			texcoord t1
			mov r1, t1
			
			mul r0, r0, r1	// r0 = distort
			
			texcoord t0
			mov r1, t0
			add r1, r1, r0 // r1 = image coordinates
			
			texreg2rgb r0, r1			
*/				
	}
}

#if !_FORCE_1_3_SHADERS_

VS2PS_Quad2 vsDx9_Flashbang(APP2VS_Quad indata)
{
	VS2PS_Quad2 outdata;	
 	outdata.Pos = vec4(indata.Pos.x, indata.Pos.y, 0, 1);
 	outdata.TexCoord0 = indata.TexCoord0;
 	outdata.TexCoord1 = indata.TexCoord0;
	return outdata;
}

PS2FB_Combine psDx9_Flashbang(VS2PS_Quad2 indata)
{
	PS2FB_Combine outdata;
	vec4 sample0 = tex2D(sampler0bilin, indata.TexCoord0);
	vec4 sample1 = tex2D(sampler1bilin, indata.TexCoord0);
	vec4 sample2 = tex2D(sampler2bilin, indata.TexCoord0);
	vec4 sample3 = tex2D(sampler3bilin, indata.TexCoord0);

	vec4 acc = sample0 * 0.5;
	acc += sample1 * 0.25;
	acc += sample2 * 0.15;
	acc += sample3 * 0.10;
	
	outdata.Col0 = acc;
	outdata.Col0.a = backbufferLerpbias;
	return outdata;
}

#else

VS2PS_Quad4 vsDx9_Flashbang(APP2VS_Quad indata)
{
	VS2PS_Quad4 outdata;	
 	outdata.Pos = vec4(indata.Pos.x, indata.Pos.y, 0, 1);
 	outdata.TexCoord0 = indata.TexCoord0;
 	outdata.TexCoord1 = indata.TexCoord0;
 	outdata.TexCoord2 = indata.TexCoord0;
 	outdata.TexCoord3 = indata.TexCoord0;
	return outdata;
}

PS2FB_Combine psDx9_Flashbang(VS2PS_Quad4 indata)
{
	PS2FB_Combine outdata;
	vec4 sample0 = tex2D(sampler0bilin, indata.TexCoord0);
	vec4 sample1 = tex2D(sampler1bilin, indata.TexCoord1);
	vec4 sample2 = tex2D(sampler2bilin, indata.TexCoord2);
	vec4 sample3 = tex2D(sampler3bilin, indata.TexCoord3);

	vec4 acc = sample0 * 0.5;
	acc += sample1 * 0.25;
	acc += sample2 * 0.15;
	acc += sample3 * 0.10;
	
	outdata.Col0 = acc;
	outdata.Col0.a = backbufferLerpbias;
	return outdata;
}
#endif

technique Flashbang
{
	pass P0
	{
		ZEnable = FALSE;
		AlphaBlendEnable = TRUE;
		SrcBlend = SRCALPHA;
		DestBlend = INVSRCALPHA;
		StencilEnable = FALSE;
		
		VertexShader = compile vs_1_1 vsDx9_Flashbang();
		PixelShader = compile LOWPSMODEL psDx9_Flashbang();
	}
}
